//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Text;
using System.Net.Sockets; 

class Sender
{

	public static void Main(string[] args)
	{	
		string address = "localhost";
		if(args.Length == 1)
			address = args[0];

		bool continueSending = true;
		while(continueSending)
		{		
			Console.WriteLine("Wprowad wiadomo do wysania. Wpisz 'quit', aby wyj.");
			string message = Console.ReadLine();
			SendMessage(message, address);
			if(message == "quit")
			{
				SendMessage(message, address);
				continueSending = false;
			}	
		}
	}

	public static void SendMessage(string message, string server)
	{
		try
		{
			Socket client = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
			IPEndPoint localEP = new IPEndPoint(IPAddress.Any, 5002);		
			client.Bind(localEP);		
			byte[] buffer = Encoding.ASCII.GetBytes(message);
			IPAddress address = Dns.Resolve(server).AddressList[0];
			IPEndPoint remoteEP = new IPEndPoint(address, 5001);
			client.SendTo(buffer, 0, buffer.Length, SocketFlags.None, remoteEP);
			client.Close();
		}
		catch(Exception ex)
		{
			Console.WriteLine(ex.ToString());
		}
	}
}
